/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker;

import LegendaryCardMaker.CardMakerToolbar;
import LegendaryCardMaker.Icon;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class TeamIconSelectorMenu
extends JMenu
implements ActionListener {
    JMenuItem newHero = new JMenuItem("New Team...");
    JMenuItem rename = new JMenuItem("Rename Team...");
    JMenuItem edit = new JMenuItem("Change Icon...");
    JMenuItem underlay = new JMenuItem("Change Underlay...");
    JMenuItem delete = new JMenuItem("Delete Team...");
    private Locale currentLocale = Locale.getDefault();
    private ResourceBundle labels = ResourceBundle.getBundle("LegendaryCardMaker.tools.language.LegendaryCardMakerMenu", this.currentLocale);
    public LegendaryCardMakerFrame lcmf;
    static CardMakerToolbar tb = null;

    public void setLanguage() {
        this.newHero.setText(this.labels.getString("NewTeam"));
        this.rename.setText(this.labels.getString("RenameTeam"));
        this.edit.setText(this.labels.getString("ChangeIcon"));
        this.underlay.setText(this.labels.getString("ChangeUnderlay"));
        this.delete.setText(this.labels.getString("DeleteTeam"));
    }

    public TeamIconSelectorMenu(LegendaryCardMakerFrame lcmf, CardMakerToolbar tb) {
        this.setLanguage();
        TeamIconSelectorMenu.tb = tb;
        this.lcmf = lcmf;
        this.setText("Edit");
        this.newHero.addActionListener(this);
        this.add(this.newHero);
        this.addSeparator();
        this.rename.addActionListener(this);
        this.add(this.rename);
        this.edit.addActionListener(this);
        this.add(this.edit);
        this.underlay.addActionListener(this);
        this.add(this.underlay);
        this.delete.addActionListener(this);
        this.add(this.delete);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name;
        if (e.getSource().equals(this.newHero)) {
            name = JOptionPane.showInputDialog(this.lcmf, "Enter the team tag", null);
            if (name == null) {
                return;
            }
            if (name != null && name.isEmpty()) {
                return;
            }
            String filePath = null;
            JFileChooser chooser = new JFileChooser();
            int outcome = chooser.showOpenDialog(this);
            if (outcome != 0) {
                return;
            }
            filePath = chooser.getSelectedFile().getAbsolutePath();
            boolean underlay = false;
            outcome = JOptionPane.showConfirmDialog(this, "Draw underlay?", "Draw Underlay?", 0, 3);
            underlay = outcome == 0;
            File newFile = new File("legendary" + File.separator + "Teams" + File.separator + chooser.getSelectedFile().getName());
            try {
                TeamIconSelectorMenu.copyFile(chooser.getSelectedFile(), newFile);
            }
            catch (IOException e1) {
                return;
            }
            Icon icon = new Icon(name.toUpperCase(), newFile.getPath(), underlay, Icon.ICON_TYPE.TEAM);
            Icon.values().add(icon);
            this.getTeamListModel().addElement(icon);
            Icon.saveIconDefinitions();
        }
        if (e.getSource().equals(this.rename)) {
            if (this.getCurrentTeam() == null) {
                return;
            }
            name = JOptionPane.showInputDialog(this.lcmf, "Enter the team tag", this.getCurrentTeam().getEnumName());
            if (name == null) {
                return;
            }
            if (name != null && name.isEmpty()) {
                return;
            }
            this.getCurrentTeam().setTagName(name);
            Icon.saveIconDefinitions();
        }
        if (e.getSource().equals(this.edit)) {
            if (this.getCurrentTeam() == null) {
                return;
            }
            String filePath = null;
            JFileChooser chooser = new JFileChooser();
            int outcome = chooser.showOpenDialog(this);
            if (outcome != 0) {
                return;
            }
            filePath = chooser.getSelectedFile().getAbsolutePath();
            File newFile = new File("legendary" + File.separator + "Teams" + File.separator + chooser.getSelectedFile().getName());
            try {
                TeamIconSelectorMenu.copyFile(chooser.getSelectedFile(), newFile);
            }
            catch (IOException e1) {
                return;
            }
            this.getCurrentTeam().setImagePath(newFile.getPath());
            Icon.saveIconDefinitions();
        }
        if (e.getSource().equals(this.underlay)) {
            if (this.getCurrentTeam() == null) {
                return;
            }
            boolean underlay = false;
            int outcome = JOptionPane.showConfirmDialog(this, "Draw underlay?", "Draw Underlay?", 0, 3);
            underlay = outcome == 0;
            this.getCurrentTeam().setUnderlayMinimized(underlay);
            Icon.saveIconDefinitions();
        }
        if (e.getSource().equals(this.delete)) {
            if (this.getCurrentTeam() == null) {
                return;
            }
            int outcome = JOptionPane.showOptionDialog(this.lcmf, "Delete Icon?", "Delete Icon?", 0, 3, null, null, null);
            if (outcome == 0) {
                Icon.values().remove(this.getCurrentTeam());
                this.getTeamListModel().removeElement(this.getCurrentTeam());
                Icon.saveIconDefinitions();
            }
        }
    }

    public JList getTeamList() {
        return this.lcmf.teamList;
    }

    public DefaultListModel getTeamListModel() {
        return this.lcmf.teamListModel;
    }

    public Icon getCurrentTeam() {
        Icon i = null;
        if (this.lcmf.teamListModel.size() > 0 && this.lcmf.teamList.getSelectedIndex() >= 0) {
            i = (Icon)this.lcmf.teamListModel.get(this.lcmf.teamList.getSelectedIndex());
        }
        return i;
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }
}

